/*
*       AF_UNIX datagram client process
*
*       This is an example program that demonstrates the use of
*       AF_UNIX datagram sockets as a BSD Sockets mechanism.  This
*       contains the client, and is intended to operate in
*       conjunction with the server program.
*
*/
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/un.h>
#include <stdio.h>
#include <signal.h>
#include <netdb.h>
#define SOCKET_PATH     "/tmp/myserver"
#define SOCKET_PATHCLNT "/tmp/my_af_unix_client"
#define bzero(ptr, len)  memset((ptr), NULL, (len))
int     timeout();
 
main()
{
        int     sock;
        int     j, slen, rlen;
        unsigned char   sdata[2000];/* send data */
        unsigned char   rdata[2000];/* receive data */
        struct  sockaddr_un servaddr;/* address of server */
        struct  sockaddr_un clntaddr;/* address of client */
        struct  sockaddr_un from;
        int     fromlen;
       
        /*      Stop the program if not done in 2 minutes */
        
        signal(SIGALRM, timeout);
        alarm((unsigned long) 120);
       
        /* Fork the server process to receive data from client */
       
        printf("Client : Forking server\n");
        if (fork() == 0 ) {
                execl("./server", "server", 0 );
                printf("Cannot exec ./server.\n");
                exit(1);
        }
        /*      Initialize the send data        */
       
        for (j = 0; j < sizeof(sdata); j++)
                sdata[j] = (char) j;
        
        /* Create a UNIX datagram socket for client */
        
        if ((sock = socket(AF_UNIX, SOCK_DGRAM, 0)) < 0) {
                perror("client: socket");
                exit(2);
        }
        
        /*      Client will bind to an address so the server will
        *       get an address in its recvfrom call and use it to
        *       send data back to the client.
        */
        bzero(&clntaddr, sizeof(clntaddr));
        clntaddr.sun_family = AF_UNIX;
        strcpy(clntaddr.sun_path, SOCKET_PATHCLNT);
       
        if (bind(sock, &clntaddr, sizeof(clntaddr)) < 0) {
                close(sock);
                perror("client: bind");
                exit(3);
        }
       
        /*      Set up address structure for server socket */
        bzero(&servaddr, sizeof(servaddr));
        servaddr.sun_family = AF_UNIX;
        strcpy(servaddr.sun_path, SOCKET_PATH);
       
        for (j = 0; j < 5; j++) {
                sleep(1);
                slen = sendto(sock, sdata, 2000, 0,
                      (struct sockaddr *) &servaddr,
                        sizeof(servaddr));
                if (slen<0) {
                      perror("client: sendto");
                      exit(4);
                }
                else {
                     printf("client : sent %d bytes\n", slen);
                     fromlen = sizeof(from);
                     rlen = recvfrom(sock, rdata, 2000, 0, &from, 
                                     &fromlen);
                     if (rlen == -1) {
                                perror("client: recvfrom\n");
                                exit(5);
                     } else
                     printf("client : received %d bytes\n", rlen);
                }
        }
        /*      Use unlink to remove the file (inode) so that the
        *       name will be available for the next run.
        */
        sleep(1);
        unlink(SOCKET_PATHCLNT);
        close(sock);
        printf("Client done\n");
        exit(0);
}
timeout() /* escape hatch so blocking calls don't wait forever */
{
        printf( "alarm went off — stopping client\n" );
        fprintf(stderr, "stopping the client process\n");
        exit(6);
}

